var sprite;
var frameIndex = 1;
var maxFrames = 18
var pulserate = 40;
var ud = "u";
var BBallType;
var dir;

list = new Array('1.png','2.png','3.png','4.png','5.png','6.png','7.png','8.png','9.png','10.png','11.png','12.png','13.png','14.png','15.png','16.png','17.png','18.png','19.png');

widget.onshow = onshow;
widget.onremove = onremove;

function setup()
{
	if(window.widget) // always check to make sure that you are running in Dashboard
	{
		// The preferences are retrieved:
		var bf = widget.preferenceForKey(createkey("BBallType"));

		if (bf) {
			BBallType = bf;
		} else {
			BBallType = "Baseball";
		}
	}
	loadup();
	setSelectors();
}

function onshow () {
	if(window.widget) {
		if (BBallType == "Random") {
			loadup();
		}
	}
}

function setUpSprite (bbt) {
	if (bbt == "Baseball") {
		frameIndex = 1;
		maxFrames = 19
		pulserate = 40;
		ud = "-";
		document.getElementById('entity').style.top = 0 + "px";
		document.getElementById('entity').style.left = 47 + "px";
	}

	if (bbt == "Bat") {
		frameIndex = 1;
		maxFrames = 11
		pulserate = 30;
		ud = "u";
		document.getElementById('entity').style.top = 0 + "px";
		document.getElementById('entity').style.left = 12 + "px";
	}

	if (bbt == "Cap") {
		frameIndex = 1;
		maxFrames = 4
		pulserate = 200;
		ud = "u";
		document.getElementById('entity').style.top = -10 + "px";
		document.getElementById('entity').style.left = 24 + "px";
	}
}

function doAnimate(sprite) {
	
	if (ud == "-") {
		frameIndex++;
		if(frameIndex == maxFrames) {
			frameIndex = 1;
		}
	} else {
		if(frameIndex == maxFrames || ud == "d") {
			ud = "d";
			frameIndex--;
		}

		if(frameIndex < 0 || ud == "u") {
			ud="u";
			frameIndex++;
		}
	}

	// change frames
	document.getElementById(sprite).src = dir + list[frameIndex];

	// do it again
	timerID = setTimeout("doAnimate('" + sprite + "')", pulserate);
	}

function cease(sprite) {
	clearTimeout(timerID);
	document.getElementById(sprite).src = dir + '1.png';
	frameIndex = 1;
	}

function getSpeedDelay() {
	obj = 40;
	return obj;
	}

function pickRandom(range) {
	return Math.round(Math.random() * (range-1));
}

function setPref(thePref) {
	if(window.widget)
	{
		BBallType = thePref;
		widget.setPreferenceForKey(thePref, createkey("BBallType"));
		loadup();
	}
}

function createkey(key)
{
	return widget.identifier + "-" + key;
}

function setSelectors() {
	var theMenuItem;

	if (BBallType == "Baseball") theMenuItem = 0;
	if (BBallType == "Bat") theMenuItem = 1;
	if (BBallType == "Cap") theMenuItem = 2;
	if (BBallType == "Random") theMenuItem = 3;
	
	document.getElementById('bballType').options[theMenuItem].selected = true;
}

function loadup(x) {
	if(x) {
		dir = x;
	} else {
		dir = BBallType;
	}

	if(dir == "Random") {
		var ic = 3;
		var bballz = new Array(ic);
		bballz[0] = "Baseball";
		bballz[1] = "Bat";
		bballz[2] = "Cap";

		var choice = pickRandom(ic);

		dir = bballz[choice];
	}

	setUpSprite(dir);

	dir += "/";
	var theSprite = document.getElementById("theSprite");
	theSprite.src = dir + "1.png";
}
	
function goHome() {
        if (window.widget)
        {
            widget.openURL('http://www.skyrocketsoftware.com/Baseballz/index.html');
        }
 }

function onremove ()
{
	if (window.widget)
	{
		widget.setPreferenceForKey (null, createkey("BBallType"));
	}
}

/*********************************/
// HIDING AND SHOWING PREFERENCES
/*********************************/

// showPrefs() is called when the preferences flipper is clicked upon.  It freezes the front of the widget,
// hides the front div, unhides the back div, and then flips the widget over.

function showPrefs()
{
	var front = document.getElementById("widget");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");		// freezes the widget so that you can change it without the user noticing
	
	front.style.display="none";		// hide the front
	back.style.display="block";		// show the back
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget over	

	document.getElementById('fliprollie').style.display = 'none';  // clean up the front side - hide the circle behind the info button

}


// hidePrefs() is called by the done button on the back side of the widget.  It performs the opposite transition
// as showPrefs() does.

function hidePrefs()
{
	var front = document.getElementById("widget");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");		// freezes the widget and prepares it for the flip back to the front
	
	back.style.display="none";			// hide the back
	front.style.display="block";		// show the front
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget back to the front
}


// PREFERENCE BUTTON ANIMATION (- the pref flipper fade in/out)

var flipShown = false;		// a flag used to signify if the flipper is currently shown or not.


// A structure that holds information that is needed for the animation to run.
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};


// mousemove() is the event handle assigned to the onmousemove property on the front div of the widget. 
// It is triggered whenever a mouse is moved within the bounds of your widget.  It prepares the
// preference flipper fade and then calls animate() to performs the animation.

function mousemove (event)
{
	if (!flipShown)			// if the preferences flipper is not already showing...
	{
		if (animation.timer != null)			// reset the animation timer value, in case a value was left behind
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; 		// set it back one frame
		
		animation.duration = 500;												// animation time, in ms
		animation.starttime = starttime;										// specify the start time
		animation.firstElement = document.getElementById ('flip');		// specify the element to fade
		animation.timer = setInterval ("animate();", 13);						// set the animation function
		animation.from = animation.now;											// beginning opacity (not ness. 0)
		animation.to = 1.0;														// final opacity
		animate();																// begin animation
		flipShown = true;														// mark the flipper as animated
	}
}

// mouseexit() is the opposite of mousemove() in that it preps the preferences flipper
// to disappear.  It adds the appropriate values to the animation data structure and sets the animation in motion.

function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}


// animate() performs the fade animation for the preferences flipper. It uses the opacity CSS property to simulate a fade.

function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.firstElement.style.opacity = animation.now;
}


// these functions are utilities used by animate()

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

// these functions are called when the info button itself receives onmouseover and onmouseout events

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}


